@extends('layouts.dash2')
@section('title', $title)
@section('content')
    <div class="content fs-6 d-flex flex-column flex-column-fluid" id="kt_content">
        <x-danger-alert />
        <x-success-alert />
     
    <div class="card w-100">
        <div class="card-header pe-5">
            <div class="card-title">
                <div class="d-flex justify-content-center flex-column me-3">
                    <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">Notifications</div>
                </div>
            </div>
            <div class="card-toolbar">
                <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" id="kt_drawer_example_basic_close">
                    <span class="svg-icon svg-icon-2">
                        <i class="fal fa-times"></i>
                    </span>
                </div>
            </div>
        </div>
        <div class="card-body text-wrap">
                        
                      
                       
                       
                       
                       
                     
                      
                    
                       
            
        </div>
    </div>
</div>

<div >
    <div wire:loading.class.delay="opacity-50" wire:target="block, unblock, terminate, loadMore">
        <div class="toolbar" id="kt_toolbar">
            <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
                <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                    <h1 class="text-dark fw-bolder my-1 fs-2">Manage Card</h1>
                    <ul class="breadcrumb fw-semibold fs-base my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('dashboard') }}" class="text-muted text-hover-primary">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('card') }}" class="text-muted text-hover-primary">Cards</a>
                        </li>
                        <li class="breadcrumb-item text-dark">Card</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center flex-nowrap text-nowrap py-1 mb-10">
                    
                    
                    
            @if($card->card_status=='0')
                    <button data-bs-toggle="modal" data-bs-target="#terminate" class="btn btn-dark me-4"><i class="fal fa-plus"></i> Create Card</button>
                  @endif 
                    <div wire:ignore.self id="kt_send_money" class="bg-white" data-kt-drawer="true" data-kt-drawer-activate="true" data-kt-drawer-toggle="#kt_send_money_button" data-kt-drawer-close="#kt_send_money_close">
                        <div class="card w-100">
                            <div class="card-header pe-5 border-0">
                                <div class="card-title">
                                    <div class="d-flex justify-content-center flex-column me-3">
                                        <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">Send Money</div>
                                    </div>
                                </div>
                                <div class="card-toolbar">
                                    <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" id="kt_send_money_close">
                                        <span class="svg-icon svg-icon-2">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body text-wrap">
                                <div class="btn-wrapper text-center mb-3">
                                    <div class="symbol symbol-100px symbol-circle me-5 mb-10">
                                        <div class="symbol-label fs-1 text-dark">
                                            <i class="fal fa-arrow-down-arrow-up fa-2x"></i>
                                        </div>
                                    </div>
                                    <p class="text-dark fs-6">Swift and Secure Money Transfer </p>
                                </div>
                                <div class="pb-5 mt-10 position-relative zindex-1">
                                    <!--begin::Item-->
                                    <a href="#">
                                        <div class="d-flex flex-stack mb-6">
                                            <div class="d-flex align-items-center me-2">
                                                <div class="symbol symbol-45px me-5">
                                                    <span class="symbol-label bg-light-primary text-dark">
                                                        <i class="fal fa-user"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <p class="fs-5 text-gray-800 text-hover-primary fw-bolder mb-0">Transfer Tag</p>
                                                    <div class="fs-7 text-gray-800 fw-semibold">Easily send money to other Konan users</div>
                                                    <div class="fs-7 text-gray-600 fw-semibold">
                                                                                                                0.1% + 0 GBP
                                                         </div>
                                                    </div>
                                                </div>
                                                <p class="btn btn-icon btn-light btn-sm">
                                                    <i class="fal fa-arrow-right text-dark"></i>
                                                </p>
                                            </div>
                                    </a>
                                    <a href="#">
                                        <div class="d-flex flex-stack mb-6">
                                            <div class="d-flex align-items-center me-2">
                                                <div class="symbol symbol-45px me-5">
                                                    <span class="symbol-label bg-light-primary text-dark">
                                                        <i class="fal fa-credit-card-front"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <p class="fs-5 text-gray-800 text-hover-primary fw-bolder mb-0">Virtual Card</p>
                                                    <div class="fs-7 text-gray-800 fw-semibold">Transfer money to other Konan users prepaid card</div>
                                                    <div class="fs-7 text-gray-600 fw-semibold">
                                                                                                                0.1% + 0 GBP
                                                         </div>
                                                    </div>
                                                </div>
                                                <p class="btn btn-icon btn-light btn-sm">
                                                    <i class="fal fa-arrow-right text-dark"></i>
                                                </p>
                                            </div>
                                    </a>
                                    <a href="#">
                                        <div class="d-flex flex-stack mb-6">
                                            <div class="d-flex align-items-center me-2">
                                                <div class="symbol symbol-45px me-5">
                                                    <span class="symbol-label bg-light-primary text-dark">
                                                        <i class="fal fa-shuffle"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <p class="fs-5 text-gray-800 text-hover-primary fw-bolder mb-0">Sepa Wire Transfer</p>
                                                    <div class="fs-7 text-gray-800 fw-semibold">Wire transfer is executed over SEPA, Iban<br> & bic are required.</div>
                                                    <div class="fs-7 text-gray-600 fw-semibold">
                                                                                                                0.3% + 0 GBP
                                                         </div>
                                                    </div>
                                                </div>
                                                <p class="btn btn-icon btn-light btn-sm">
                                                    <i class="fal fa-arrow-right text-dark"></i>
                                                </p>
                                            </div>
                                    </a>
                                    <a href="#">
                                        <div class="d-flex flex-stack mb-6">
                                            <div class="d-flex align-items-center me-2">
                                                <div class="symbol symbol-45px me-5">
                                                    <span class="symbol-label bg-light-primary text-dark">
                                                        <i class="fal fa-shuffle"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <p class="fs-5 text-gray-800 text-hover-primary fw-bolder mb-0">Faster Payment</p>
                                                    <div class="fs-7 text-gray-800 fw-semibold">Wire transfer is executed over Faster Payments,<br> Account number & sort code are required.</div>
                                                    <div class="fs-7 text-gray-600 fw-semibold">
                                                                                                                0.6% + 0 GBP
                                                         </div>
                                                    </div>
                                                </div>
                                                <p class="btn btn-icon btn-light btn-sm">
                                                    <i class="fal fa-arrow-right text-dark"></i>
                                                </p>
                                            </div>
                                    </a>
                                    <!--end::Item-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <button data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end" class="btn btn-dark"><i class="fal fa-circle-chevron-down"></i> More Options</button>
                    <div wire:ignore.self class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px py-3" data-kt-menu="true">
                        <div class="menu-item px-3">
                            <a href="#" class="menu-link px-3 py-3" data-bs-toggle="modal" data-bs-target="#fund">
                                <i class="fal fa-arrow-down me-3"></i> Fund Card
                            </a>
                        </div>
                        <div class="menu-item px-3">
                            <a href="#" class="menu-link px-3 py-3" data-bs-toggle="modal" data-bs-target="#withdraw">
                                <i class="fal fa-university me-3"></i> Withdraw to Account
                            </a>
                        </div>
                                                <div class="menu-item px-3">
                              @if($card->status=='Active')                  
                            <a href="freeze" class="menu-link px-3 py-3" >
                                <i class="fal fa-snowflake me-3"></i> Freeze Card
                            </a>
                            @else

                            <a href="unfreeze" class="menu-link px-3 py-3" >
                                <i class="fal fa-snowflake me-3"></i> Unfreeze Card
                            </a>
                            @endif
                        </div>
                                                {{-- <div class="menu-item px-3">
                            <a href="#" class="menu-link px-3 py-3" id="kt_settings_button">
                                <i class="fal fa-cog me-3"></i> Card Settings
                            </a>
                        </div> --}}
                        
                    </div>
                    <div wire:ignore.self class="modal fade" id="fund" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h3 class="modal-title">Fund Card</h3>
                                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                        <span class="svg-icon svg-icon-1">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="modal-body">
                                    <form action='{{ route('fundcard') }}' method="post">
                                        @csrf
                                        <div class="fv-row mb-6">
                                            <div class="input-group mb-3">
                                                <span class="input-group-text border-0 fs-2">{{ $settings->currency }}</span>
                                                <input class="form-control form-control-lg form-control-solid fs-2 fw-bold " type="text" step="any" name='amount' autocomplete="transaction-amount" id="amountFund" min="1" max="1.15" value="" required placeholder="0.00" />
                                                <span class="input-group-text border-0"><span class="fal fa-credit-card fis rounded-4 me-3 fs-1"></span></span>
                                            </div>
                                                                                    </div>
                                        <div class="bg-light-primary px-6 py-5 mb-10 rounded" >
                                            <p class="text-dark fw-bold fs-6 mb-0">Balance before transaction: <span id="balanceAfterFund">{{ $settings->currency }} {{ number_format(Auth::user()->account_bal,2,) }} {{ $settings->s_currency }}</span></p>
                                            <p class="text-dark fw-bold fs-6 mb-0">Fee: <span id="feeFund">{{ $settings->currency }} 0.00 {{ $settings->s_currency }}</span></p>
                                        </div>
                                        <div class="text-center mt-10">
                                            <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
                                                <span >Fund Card</span>
                                               
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:ignore.self class="modal fade" id="withdraw" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h3 class="modal-title">Withdraw to Account</h3>
                                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                        <span class="svg-icon svg-icon-1">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="modal-body">
                                    <form action='{{ route('withdrawcard') }}' method="post">
                                        @csrf
                                        <div class="fv-row mb-6">
                                            <div class="input-group mb-3">
                                                <span class="input-group-text border-0 fs-2">{{ $settings->currency }}</span>
                                                <input class="form-control form-control-lg form-control-solid fs-2 fw-bold " type="text" step="any" name="amount" autocomplete="transaction-amount" id="amountWithdraw" min="1" max="1.15" value="" required placeholder="0.00" />
                                                <span class="input-group-text border-0"><span class="fal fa-credit-card rounded-4 me-3 fs-1"></span></span>
                                            </div>
                                                                                    </div>
                                        <div class="bg-light-primary px-6 py-5 mb-10 rounded" >
                                            <p class="text-dark fw-bold fs-6 mb-0">Balance after transaction: <span id="balanceAfterWithdraw">{{ $settings->currency }} {{ number_format(Auth::user()->account_bal,2,) }} {{ $settings->s_currency }}</span></p>
                                            <p class="text-dark fw-bold fs-6 mb-0">Fee: <span id="feeWithdraw">{{ $settings->currency }}0.00 {{ $settings->s_currency }}</span></p>
                                        </div>
                                        <div class="text-center mt-10">
                                            <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
                                                <span>Withdraw from Card</span>
                                                {{-- <span wire:loading wire:target="withdraw">Processing Transfer to Account...</span> --}}
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:ignore.self class="modal fade" id="terminate" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h3 class="modal-title">Create  Card</h3>
                                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                        <span class="svg-icon svg-icon-1">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="modal-body">
                                    <p>A prepaid card has its own balance and can have
                                        funds transferred to it.</p>
                                    <form action='{{ route('createcard') }}' method="post">
                                        @csrf
                                        <div class="input-group mb-3">
                                            <span class="input-group-text border-0 fs-2">{{ $settings->s_currency }}</span>
                                            <input class="form-control form-control-lg form-control-solid fs-2 fw-bold " type="text" step="any" name="amount" autocomplete="transaction-amount" id="amount" min="1" max="1.15" value="" required placeholder="0.00" />
                                            <span class="input-group-text border-0"><span class="fal fa-credit-card rounded-4 me-3 fs-1"></span></span>
                                        </div>
                                        
                                                                                <div class="text-center">
                                            <button type="submit" class="btn btn-primary btn-block">
                                                <span >Create Card</span>
                                                
                                            </button>
                                        </div>
                                    </form>


                                    
                                </div>
                            </div>
                        </div>

                        
                    </div>
                    <div wire:ignore.self id="kt_settings" class="bg-white" data-kt-drawer="true" data-kt-drawer-activate="true" data-kt-drawer-toggle="#kt_settings_button" data-kt-drawer-close="#kt_settings_close" data-kt-drawer-width="{'md': '500px'}">
                        <div class="card w-100">
                            <div class="card-header pe-5 border-0">
                                <div class="card-title">
                                    <div class="d-flex justify-content-center flex-column me-3">
                                        <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">Card Settings</div>
                                    </div>
                                </div>
                                <div class="card-toolbar">
                                    <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" id="kt_settings_close">
                                        <span class="svg-icon svg-icon-2">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body text-wrap">
                                <div class="btn-wrapper text-center mb-3">
                                    <div class="symbol symbol-100px symbol-circle me-5 mb-10">
                                        <div class="symbol-label fs-1 text-dark">
                                            <i class="fal fa-cogs fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-5 mt-10 position-relative zindex-1">
                                    <form wire:submit.prevent="configureCard" method="post">
                                        <div class="d-flex flex-stack">
                                            <div class="d-flex">
                                                <div class="d-flex flex-column">
                                                    <h5>Min Transaction</h5>
                                                    <p class="fs-7">If the transaction amount is less than this value, then the transaction will be declined.</p>
                                                                                                    </div>
                                            </div>
                                            <div class="d-flex justify-content-end">
                                                <input class="form-control form-control-lg form-control-solid" type="number" wire:model="min_trx">
                                            </div>
                                        </div>
                                        <div class="separator separator-dashed my-5"></div>
                                        <div class="d-flex flex-stack">
                                            <div class="d-flex">
                                                <div class="d-flex flex-column">
                                                    <h5>Max Transaction</h5>
                                                    <p class="fs-7">If the transaction amount is less than this value, then the transaction will be declined.</p>
                                                                                                    </div>
                                            </div>
                                            <div class="d-flex justify-content-end">
                                                <input class="form-control form-control-lg form-control-solid" type="number" wire:model="max_trx">
                                            </div>
                                        </div>
                                        <div class="separator separator-dashed my-5"></div>
                                        <div class="table-responsive">
                                            <table class="table table-row-dashed border-gray-300 align-middle gy-6">
                                                <tbody class="fs-6 fw-semibold">
                                                    <!--begin::Table row-->
                                                    <tr>
                                                        <td class="min-w-400px">
                                                            <h5>Contactless</h5>
                                                            <p class="fs-7">Indicates if a contactless transaction is allowed on this card.</p>
                                                        </td>
                                                        <td class="w-125px">
                                                            <div class="form-check form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" wire:model="contactless">
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="min-w-400px">
                                                            <h5>ATM</h5>
                                                            <p class="fs-7">Indicates if an ATM Withdrawal transaction is allowed on this card.</p>
                                                        </td>
                                                        <td class="w-125px">
                                                            <div class="form-check form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" wire:model="atm">
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="min-w-400px">
                                                            <h5>Online Transactions</h5>
                                                            <p class="fs-7">Indicates if an online transaction is allowed on this card.</p>
                                                        </td>
                                                        <td class="w-125px">
                                                            <div class="form-check form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" wire:model="online">
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="min-w-400px">
                                                            <h5>Cashback</h5>
                                                            <p class="fs-7">Indicates if a cashback transaction at a physical terminal is allowed on this card.</p>
                                                        </td>
                                                        <td class="w-125px">
                                                            <div class="form-check form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" wire:model="cashback" checked>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="min-w-400px">
                                                            <h5>Credit Authorisations</h5>
                                                            <p class="fs-7">Indicates if a this card can receive a credit transaction.</p>
                                                        </td>
                                                        <td class="w-125px">
                                                            <div class="form-check form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" wire:model="credit_auth">
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <!--begin::Table row-->
                                                </tbody>
                                            </table>
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary btn-block">
                                                    <span wire:loading.remove wire:target="configureCard">Save Configuration</span>
                                                    <span wire:loading wire:target="configureCard">Updating card...</span>
                                                </button>
                                            </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="row g-xl-8">
                <div class="col-md-4">
                    <div class="card mb-6 rounded-4">
                        <div class="card-body dd-bg">
                            <div class="row mb-6">
                                <div class="col-6">
                                    <h4 class="text-dark">{{ $settings->currency }} {{ number_format($card->amount,1, '.', ',')}} {{ $settings->s_currency }}</h4>
                                </div>
                                <div class="col-6 text-end">
                                    <img style="height:auto; max-width:40%;" src="{{ asset('storage/app/public/mastercard.png')}} ">
                                </div>
                            </div>
                            <div class="row mb-6">
                                <div class="col-12 text-center">
                                    <h2 class="mb-3 text-dark h1"><span id="cardNumber"> {{ $card->card_number }}</span></h2>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-8">
                                    @if($card->status == 'Not Active')
                                    <span class="badge badge-pill badge-secondary badge-sm text-dark">{{ $card->status }}</span>
                                    @else
                                    <span class="badge badge-pill badge-success badge-sm text-dark">{{ $card->status }}</span>
                                    @endif
                                </div>
                                <div class="col-4 text-end">
                                    <p class="text-dark mb-0 "><span id="cvv">{{ $card->cvv }}</span></p>
                                    <span class="text-dark text-xs">CVV</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white px-6 py-5 mb-10 rounded-4">
                        <p class="text-dark fs-5 fw-bolder">Card Details</p>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Name In Card: {{ $card->name }} <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="{{ $card->name }}" title="Copy"></i></span>
                        </li>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Card Number: {{ $card->card_number }} <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="{{ $card->card_number }}" title="Copy"></i></span>
                        </li>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>EXP: {{ $card->expiry }} <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="{{ $card->expiry }}" title="Copy"></i></span>
                        </li>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>CVV: {{ $card->cvv }}<i class="fal fa-clone castro-copy fs-5" data-clipboard-text="Address line 1" title="Copy"></i></span>
                        </li>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Card Type:  {{ $card->type }}<i class="fal fa-clone castro-copy fs-5" data-clipboard-text=" {{ $card->type }}" title="Copy"></i></span>
                        </li>
                        {{-- <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>City: City <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="City" title="Copy"></i></span>
                        </li>
                        <li class="d-flex align-items-center py-2">
                            <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Postal Code: AL3 8QE <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="AL3 8QE" title="Copy"></i></span>
                        </li> --}}
                    </div>
                </div>
                <div class="col-md-8">
                    <div wire:id="KN2WMCiMi8MgnqTqz4kL" wire:initial-data="{&quot;fingerprint&quot;:{&quot;id&quot;:&quot;KN2WMCiMi8MgnqTqz4kL&quot;,&quot;name&quot;:&quot;transactions.card&quot;,&quot;locale&quot;:&quot;en&quot;,&quot;path&quot;:&quot;user\/card\/manage\/95a1fa51-88b7-4773-acc9-0e07b355976d&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;v&quot;:&quot;acj&quot;},&quot;effects&quot;:{&quot;listeners&quot;:[]},&quot;serverMemo&quot;:{&quot;children&quot;:[],&quot;errors&quot;:[],&quot;htmlHash&quot;:&quot;6b59b225&quot;,&quot;data&quot;:{&quot;perPage&quot;:20,&quot;user&quot;:[],&quot;admincheck&quot;:0,&quot;card&quot;:[],&quot;search&quot;:&quot;&quot;,&quot;status&quot;:&quot;&quot;,&quot;exportType&quot;:null,&quot;exportAs&quot;:null,&quot;date&quot;:null,&quot;orderBy&quot;:&quot;desc&quot;},&quot;dataMeta&quot;:{&quot;models&quot;:{&quot;user&quot;:{&quot;class&quot;:&quot;App\\Models\\User&quot;,&quot;id&quot;:&quot;92647996-3b3d-4510-895d-2b1a85d093e0&quot;,&quot;relations&quot;:[&quot;getCountrySupported&quot;,&quot;getCountrySupported.real&quot;,&quot;business&quot;],&quot;connection&quot;:&quot;mysql&quot;,&quot;collectionClass&quot;:null},&quot;card&quot;:{&quot;class&quot;:&quot;App\\Models\\Virtual&quot;,&quot;id&quot;:&quot;95a1fa51-88b7-4773-acc9-0e07b355976d&quot;,&quot;relations&quot;:[],&quot;connection&quot;:&quot;mysql&quot;,&quot;collectionClass&quot;:null}}},&quot;checksum&quot;:&quot;7bcba666569027900ee98b7188984b1e404707fc38ef8a212c9728bcd6128149&quot;}}">
    <div class="row g-xl-8">
        <div wire:ignore.self class="modal fade" id="filter" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">Filter Transaction</h3>
                        <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                            <span class="svg-icon svg-icon-1">
                                <i class="fal fa-times"></i>
                            </span>
                        </div>
                    </div>
                    <div class="modal-body">
                        <div class="fv-row mb-6">
                            <label class="form-label fs-6 fw-bolder text-dark">Date Range</label>
                            <input class="form-control form-control-lg form-control-solid" placeholder="Pick date rage" value="1704386312416 - 1704386312416" name="date" id="range" onchange="this.dispatchEvent(new InputEvent('input'))" wire:model="date">
                        </div>
                        <div class="fv-row mb-6">
                            <label class="form-label fs-6 fw-bolder text-dark">Status</label>
                            <select class="form-select form-select-solid" wire:model="status">
                                <option value="">Select status</option>
                                <option value="COMPLETED">Completed</option>
                                <option value="PENDING">Pending</option>
                            </select>
                        </div>
                        <div class="fv-row mb-6">
                            <label class="form-label fs-6 fw-bolder text-dark">Sort by</label>
                            <select class="form-select form-select-solid" wire:model="orderBy">
                                <option value="asc">ASC</option>
                                <option value="desc">DESC</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div wire:ignore.self class="modal fade" id="export" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">Export Transactions</h3>
                        <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                            <span class="svg-icon svg-icon-1">
                                <i class="fal fa-times"></i>
                            </span>
                        </div>
                    </div>
                    <form wire:submit.prevent="save(Object.fromEntries(new FormData($event.target)))">
                        <div class="modal-body">
                            <input type="hidden" name="_token" value="HLnl1V9bCl0L3nRb0QC5WvGOCRWZu54r6nbDSq33">                            <div class="fv-row mb-6">
                                <label class="form-label fs-6 fw-bolder text-dark">File Format</label>
                                <select class="form-select form-select-solid" name="exportType" required>
                                    <option value="">Select file type</option>
                                    <option value="csv">CSV</option>
                                    <option value="excel">Excel</option>
                                </select>
                            </div>
                                                        <div class="fv-row mb-6">
                                <label class="form-label fs-6 fw-bolder text-dark">Export as</label>
                                <select class="form-select form-select-solid" name="exportAs" required>
                                    <option value="">How do you want to receive this file?</option>
                                    <option value="download">Download file</option>
                                    <option value="email">Send file to email</option>
                                </select>
                            </div>
                                                    </div>
                        <div class="modal-footer">
                            <button class="btn btn-block btn-primary" type="submit"><i class="fal fa-file-export"></i>
                                <span wire:loading.remove wire:target="save">Export</span>
                                <span wire:loading wire:target="save">Exporting file...</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <div class="card rounded-4">
                <div class="card-body">
                    <div class="row mb-6">
                        
                    </div>
                   
                                        <div class="" wire:loading.class.delay="opacity-50" wire:target="search, status, orderBy, perPage, date">
                        <div class="table-responsive">
                            <table class="table align-middle table-row-bordered table-row-gray-300 gy-5 gs-7" id="kt_datatable_example_5">
                                <thead>
                                    
                                    <tr class="text-start text-dark fw-bolder fs-6 text-uppercase px-7">
                                        <th></th>
                                        <th class="min-w-150px">Amount</th>
                                        <th class="min-w-50px">Reference ID</th>
                                        <th class="min-w-200px">Created</th>
                                    </tr>
                                    <!--end::Table row-->
                                </thead>
                                <tbody class="fw-semibold text-dark fs-6">
                                    @forelse($card_records as $card_record)
                                    <tr class="cursor-pointer" id="kt_trx_111698661029511197_button">
    <td>
        <div class="symbol symbol-40px symbol-circle me-5">
            <div class="symbol-label fs-3 fw-bolder text-dark">
                @if($card_record->type=='Credit')
                                <i class="fal fa-plus"></i>
                    @else
                    <i class="fal fa-minus"></i>
                    @endif
                            </div>
        </div>
    </td>
    <td>{{ $settings->currency }}{{ $card_record->amount }}{{ $settings->s_currrency }}</td>
    <td>{{ $card_record->reference }}</td>
    <td>{{ \Carbon\Carbon::parse($card_record->created_at)->toDayDateTimeString() }}</td>
    @empty

<h3> No Card Transaction </h3>

</tr>
@endforelse


                                </tbody>
                            </table>
                                                    </div>
                    </div>
                </div>
                            </div>
        </div>
    </div>
    <div  class="bg-white" data-kt-drawer="true" data-kt-drawer-activate="true" data-kt-drawer-toggle="#kt_trx_111698661029511197_button" data-kt-drawer-close="#kt_trx_111698661029511197_close">
    <div class="card w-100">
        <div class="card-header pe-5 border-0">
            <div class="card-title">
                <div class="d-flex justify-content-center flex-column me-3">
                    <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">Transaction Details</div>
                </div>
            </div>
            <div class="card-toolbar">
                <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" ">
                    <span class="svg-icon svg-icon-2">
                        <i class="fal fa-times"></i>
                    </span>
                </div>
            </div>
        </div>
        <div class="card-body text-wrap">
            <div class="btn-wrapper text-center mb-3">
                <div class="symbol symbol-100px symbol-circle me-5 mb-10">
                    <div class="symbol-label fs-1 text-dark">
                                                <i class="fal fa-plus fa-2x"></i>
                                            </div>
                </div>
                <p class="text-dark fs-1 fw-bolder">£1.00 GBP</p>
            </div>
            <div class="d-flex flex-column">
                <li class="d-flex align-items-center py-2">
                    <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Reference: 111698661029511197 <i class="fal fa-clone castro-copy fs-5" data-clipboard-text="111698661029511197" title="Copy"></i></span>
                </li>
                <li class="d-flex align-items-center py-2">
                    <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Charge: £0.00 GBP</span>
                </li>
                <li class="d-flex align-items-center py-2">
                    <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Date: Thu, Jan 4, 2024 4:38 PM</span>
                </li>
                                <li class="d-flex align-items-center py-2">
                    <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>Status: <span class="badge badge-pill badge-secondary badge-sm">Completed</span></span>
                </li>
                                                                <li class="d-flex align-items-center py-2">
    <span class="bullet me-5 bg-primary bullet-vertical"></span> <span>**** 4943 </span>
</li>
                                            </div>
        </div>
    </div>
</div>

</div>
<!-- Livewire Component wire-end:KN2WMCiMi8MgnqTqz4kL -->                </div>
            </div>
        </div>
    </div>
</div>
</div>
<!-- Livewire Component wire-end:cavszLaYf1ubXIcCtpHy -->
    </div>
    @endsection